﻿using System;

namespace Winson.EntityOP.Entity
{	
	/// <summary>
    /// Order Details表实体类
    /// </summary>
	public class OrderDetailsDS
    {
        public OrderDetailsDS(){}
        
		#region 成员
		/// <summary>
		/// 获取或设置Orderid(可读写)
		/// </summary>
		public int Orderid{get;set;}
		/// <summary>
		/// 获取或设置Productid(可读写)
		/// </summary>
		public int Productid{get;set;}
		/// <summary>
		/// 获取或设置Unitprice(可读写)
		/// </summary>
		public decimal Unitprice{get;set;}
		/// <summary>
		/// 获取或设置Quantity(可读写)
		/// </summary>
		public short Quantity{get;set;}
		/// <summary>
		/// 获取或设置Discount(可读写)
		/// </summary>
		public float Discount{get;set;}
		/// <summary>
		/// 获取字段数量(只读)
		/// </summary>
        public int Count{get { return 5; }}
        #endregion

		#region 索引器
        public object this[int index, int type, int maxID]
        {			 
			get
			{
				if(type==1)
                {
                    #region 返回字段名
                    switch (index)
                    {
						 case 0:
							 if (maxID > 0 || Orderid > 0)
								 return "Orderid";
							 else
								 return null;
						 case 1:
							 if(Productid > 0)
								 return "Productid";
							 else
								 return null;
						 case 2:
							 if(Unitprice > 0)
								 return "Unitprice";
							 else
								 return null;
						 case 3:
						 case 4:
                        default:
                            return null;                           
                    }
                    #endregion
                }
                else
                {
                    #region 返回字段值
                    switch (index)
                    {
						 case 0:
							 if (maxID > 0)
								 return maxID;
							 else if(Orderid > 0)
								 return  Orderid;
							 else
								 return null;
						 case 1:
								 return Productid;
						 case 2:
								 return Unitprice;
						 case 3:
								 return Quantity;
						 case 4:
								 return Discount;
                        default:
                            return null;                           
                    }
                    #endregion
                }
			}	            
        }
		#endregion
	}
}


